using System;
using System.Collections.Generic;

public class Programme
{
    public static void Main(string[] args)
    {
        string[] input = Console.ReadLine().Split(' ');
        long n = long.Parse(input[0]);
        int k = int.Parse(input[1]);
        input = Console.ReadLine().Split(' ');
        long[] arr = new long[k];
        Dictionary<long, HashSet<long>> hashFactors = new Dictionary<long, HashSet<long>>();
        for (int i = 0; i < k; i++)
        {
            arr[i] = long.Parse(input[i]);
        }
        foreach (long number in arr)
        {
            hashFactors[number] = factors(number, hashFactors);
        }
        for (int i = 0; i < k; i++)
        {
            if (i == 0)
            {
                Console.Write(XOR(arr[i], hashFactors));
            }
            else
            {
                Console.Write(" " + XOR(arr[i], hashFactors));
            }
        }
    }
    public static long XOR(long number, Dictionary<long, HashSet<long>> hashFactors)
    {
        long n = 0;
        foreach (long factor in hashFactors[number])
        {
            n ^= factor;
        }
        return n;
    }
    public static HashSet<long> factors(long n, Dictionary<long, HashSet<long>> hashFactors)
    {
        hashFactors[n] = new HashSet<long>();
        for (long i = (long)Math.Round(Math.Sqrt(n)); i > 1; i--)
        {
            if (n % i == 0)
            {
                if (!hashFactors.ContainsKey(i))
                {
                    hashFactors[n].Add(i);
                }
                else
                {
                    hashFactors[n].UnionWith(hashFactors[i]);
                }
                if (i != n / i)
                {
                    if (!hashFactors.ContainsKey(n / i))
                    {
                        hashFactors[n].Add(n / i);
                    }
                    else
                    {
                        hashFactors[n].UnionWith(hashFactors[n / i]);
                    }
                }
            }
        }
        hashFactors[n].Add(1);
        hashFactors[n].Add(n);
        return hashFactors[n];
    }
}